/*******************************************************************************
 * Copyright (c) 2000, 2011 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Jesper Kamstrup Linnet (eclipse@kamstrup-linnet.dk) - initial API and implementation
 * 			(report 36180: Callers/Callees view)
 *******************************************************************************/
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.Collection;

import org.eclipse.core.runtime.IProgressMonitor;

import org.eclipse.jdt.core.IType;

public interface IImplementorFinder {

    /**
     * Find implementors of the specified IType instance.
     */
    Collection<IType> findImplementingTypes(IType type,
        IProgressMonitor progressMonitor);

    /**
     * Find interfaces which are implemented by the specified IType instance.
     */
    Collection<IType> findInterfaces(IType type, IProgressMonitor progressMonitor);
}
